jQuery(document).ready(function() 
{
    jQuery('#engage_inbound_event').change(function() 
    {
        jQuery('#engage-form-fields').html(""); 
        jQuery('img.engage-loading').show();
        var wordPressInboundID = jQuery(this).val();

        if(wordPressInboundID > 0) 
        {
            var data = {
                action: 'getinboundevent',
                inboundeventid: wordPressInboundID
            };
            
            jQuery.ajax({
                url: '/wp-content/plugins/engage/Proxies/ProxyMapper.php', // Path to your PHP file
                type: 'POST',
                data: data,
                success: function(response) {
                    jQuery('img.engage-loading').hide();
                    jQuery('#engage-form-fields').html(response);                    
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    jQuery('img.engage-loading').hide();
                    jQuery('#engage-form-fields').html('Could not load the engage inbound events');
                }
            });
        }
        else 
        {
			jQuery('img.engage-loading').hide();
            jQuery('#engage-form-fields').html('<p>Select an inbound event</p>');
        }
    });

    jQuery('#engage_submit_form').click(function(e) 
    {
        e.preventDefault();
        var engage_form_nonce = jQuery("#engage_form_nonce").val();
        var inboundEventId = jQuery("#engage-inbound-event-id").val();
        var email = '';

        // Remove previous error classes and messages within the form
        jQuery('#engage-form-main .error').removeClass('error');
        jQuery('#engage-form-main .engage_error').text('').hide();

        // Initialize a flag to check if the form is valid
        let formValid = true;

        // Loop through each required field within the form
        jQuery('#engage-form-main input[required], #engage-form-main textarea[required]').each(function() {
            if (jQuery(this).val().trim() === '') {
                // Add error class to the empty required field
                jQuery(this).addClass('error');
                // Show error message
                jQuery(this).next('.engage_error').text('This field is required.').show();
                // Set formValid to false
                formValid = false;
            }
        });

        if(formValid) 
        {    
            var data = {};
            jQuery('#engage-form-main').find('input[name^="field_"], textarea[name^="field_"]').each(function() {
                var formName = this.name.replace('field_', '');
        
                if (jQuery(this).is(':checkbox')) {
                    data[formName] = jQuery(this).is(':checked');
                } else if (formName.toLowerCase() === "email") {
                    email = jQuery(this).val();
                } else {
                    data[formName] = jQuery(this).val();
                }
            });
        
            var postData = {
                action: 'sendinboundevent',
                engageFormNonce: engage_form_nonce,
                inboundEventId: inboundEventId,
                email: email,
                data: data
            };

            jQuery('#engage-form-main').hide();
            jQuery('#engage-form-loading img').show();
            
        
            jQuery.ajax({
                url: '/wp-content/plugins/engage/Proxies/ProxyMapper.php', // Path to your PHP file
                type: 'POST',
                data: postData,
                success: function(response) 
                {
                    // On successful AJAX call, hide the form and show the confirmation message
                    var formAction = jQuery('#engage-form-main').attr('action');

                    if (typeof formAction === 'undefined' || formAction === '') {
                        jQuery('#engage-form-loading img').hide();
                        jQuery('#engage-confirmation').show();
                    }
                    else 
                    {
                        window.location.href = formAction;
                    }
                },
                error: function(xhr, status, error) 
                {
                    var errorMessage = 'An unexpected error occurred. Please try again later.'; 

                    try 
                    {
                        var response = JSON.parse(xhr.responseText);
                        if (response.message) {
                            errorMessage = response.message;
                        }
                    } catch (e) {
                        console.error('Failed to parse JSON response:', e);
                    }
                    jQuery('#engage-form-loading img').hide();
                    jQuery('#engage-confirmation').html(errorMessage);
                    jQuery('#engage-confirmation').show();
                }
            });
        }
    });

    jQuery(document).on('change', 'select.form-management-field-type', function() {
        var selectedValue = jQuery(this).val();
        
        // Get the field number from the select element's name attribute
        var fieldName = jQuery(this).attr('name');
        var fieldRequired = fieldName.replace('field_type_', 'field_required_');
        
        // Find the corresponding input element
        var $inputElement = jQuery('input[name="' + fieldRequired + '"]');
        
        // If selected value is "checkbox", set the input element to checked and disabled
        if (selectedValue === "checkbox") {
            $inputElement.prop('checked', true).prop('disabled', true);
        } else {
            // Otherwise, enable the input element
            $inputElement.prop('checked', false).prop('disabled', false);
        }
    });
});
