<?php

namespace Engage\ShortCode;

use Engage\DB;
use Engage\Helpers;
use Engage\Helpers\LogHelper;

class FormRender 
{
    public function engage_shortcode_formrender($atts) 
    {
        $output = '<div class="wp-block-spacer" id="engage-form">';
        $formNotLoadedMsg = "<p>Apologies, we're unable to load the form at the moment. Please try again later or contact support for assistance.</p>";

        try
        {
            $this->enqueue_engage_assets();
            // Extract shortcode attributes
            $atts = shortcode_atts(
                array(
                    'formid' => 0,
                    'formaction' => '',
                ),
                $atts
            );

            // Access parameters
            $formId = $atts['formid'];
            $formaction = $atts['formaction'];

            if($formId != null && $formId > 0) 
            {
                LogHelper::WriteDebug('FormRender.php - Load Form with ID (' . $formId . ') and FormAction (' . $formaction . ').');
                $dbaccess = new DB\DBAccess();
                $engageFormModel = $dbaccess->engage_dbaccess_get_engage_form($formId);

                if($engageFormModel != null) 
                {
                    LogHelper::WriteDebug('FormRender.php - Form Model data:');
                    LogHelper::WriteDebug($engageFormModel);

                    $output .= '<form action="' . $formaction . '" method="post" id="engage-form-main">';
                    //$output .= wp_nonce_field( 'engage_form_nonce', 'engage_form_nonce' );
                    $output .= wp_nonce_field('engage_form_nonce', 'engage_form_nonce', true, false);
                    $output .= '<input type="hidden" name="engage-inbound-event-id" id="engage-inbound-event-id" value=' . $engageFormModel->InboundEventId . ' />';
                    $output .= '<table>';
                    $formHelper = new Helpers\FormHelper();

                    $fieldRows = [];

                    foreach ($engageFormModel->Fields as $formField) 
                    {
                        $fieldName = $formField['name']; 
                        $fieldLabel = $formField['label'];                    
                        $fieldType = $formField['type'];
                        $fieldRequired = $formField['required'];
                        $fieldOrder = $formField['order'];

                        $fieldRow = $formHelper->GetFormElement($fieldName, $fieldLabel, $fieldType, $fieldRequired);
                        $fieldRows[$fieldOrder] = $fieldRow;
                    }

                    // Sort the array keys numerically
                    ksort($fieldRows);

                    // Print the <tr> contents in sorted order
                    foreach ($fieldRows as $fieldRow) {
                        $output .= $fieldRow;
                    }

                    $output .= '<tr>
                                    <td colspan="2">
                                        <p class="submit">
                                            <input type="submit" id="engage_submit_form" name="engage_submit_form" class="button-primary" value="Submit" />
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </form>';
                    $output .= '<div id="engage-form-loading"><img class="engage-loading" src="' . ENGAGE_PLUGIN_URL . '/assets/loading.gif"/></div>';
                    $output .= '<div id="engage-confirmation" style="display:none;">' . $engageFormModel->Confirmation . '</div>';
                }
                else 
                {
                    LogHelper::WriteError('FormRender.php - Could not render form from database. Check if the formid (' . $formId . ') exists.');
                    $output .= $formNotLoadedMsg;
                }
            }
            else {
                LogHelper::WriteError('FormRender.php - Could not render form. Check if the attributes are valid.');
                LogHelper::WriteError($atts);
                $output .= $formNotLoadedMsg;
            }
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('FormRender.php - Could not render form - Caught exception: ' . $e->getMessage());
            LogHelper::WriteError($atts);
            $output .= $formNotLoadedMsg;
        } 
        
        $output .= '</div>';
        return $output;
    }

    public function enqueue_engage_assets() {
        // Init javascript files
        wp_register_script('engage-script', plugins_url('/../js/engagescript.js', __FILE__), array('jquery'), '1.0', true);
        wp_enqueue_script('engage-script');
    
        // Init css files
        wp_register_style('engage-style', plugins_url('/../css/style.css', __FILE__), array(), '1.0', 'all');
        wp_enqueue_style('engage-style');
    }
}  

$formRender = new FormRender();
add_shortcode('engage_form', array($formRender, 'engage_shortcode_formrender'));

?>