<?php
namespace Engage\Settings;

use Engage\Model;
use Engage\DB;
use Engage\Proxies;
use Engage\Helpers\LogHelper;

class SettingsOverviewForms
{
    function engage_settings_overviewforms() 
    {
        $success_message = '';
        $error_message = '';
        $apiStatusResult = false;
        $proxyengage = new Proxies\Proxy();
        $apiStatusResult = $proxyengage->engage_proxyengage_validate();        

        if(!$apiStatusResult) 
        {
            LogHelper::WriteWarning('SettingsOverviewForms.php - Api credentials invalid, redirect to the Api Settings page');
            echo '<meta http-equiv="refresh" content="0;url=' . get_home_url() . '/wp-admin/admin.php?page=engage-settings-api-settings" />';
            exit;
        }

        LogHelper::WriteDebug('SettingsOverviewForms.php - Get all created Forms');
        $dbaccess = new DB\DBAccess();
        $engage_forms = $dbaccess->engage_dbaccess_get_engage_forms();

        LogHelper::WriteDebug('SettingsOverviewForms.php - Get all inbound events');
        $proxyengage = new Proxies\Proxy();
        $engageInboundEventModel = $proxyengage->engage_proxyengage_getinboundevents();
            
        /* Start rendering snippet */
        echo '<div class="postbox" id="engage_settings_overview">
                    <div class="inside">';
                echo '<h3 class="hndle">Forms Overview</h3>';
                echo '<table>
                        <tr>
                            <th>ID</th>
                            <th>Inbound Event</th>
                            <th>Name</th>
                            <th style="width:400px;">Fields</th>
                            <th>Edit</th>
                        </tr>';
                        if($engage_forms != null && count($engage_forms) > 0) 
                        {
                            foreach ($engage_forms as $form) 
                            {
                                echo '<tr>
                                        <td class="column-id">' . $form->Id . '</td>
                                        <td class="column-inboundevent">' . $this->engage_settings_getinboundeventname($engageInboundEventModel, $form->InboundEventId) . '</td>
                                        <td class="column-name">' . $form->Name . '</td>';
                                echo    '<td class="column-fields"><ul>';
                                foreach ($form->Fields as $field) 
                                {
                                    $isFieldRequired = $field['required'] ? 'true' : 'false';
                                    echo '<li>[' . $field['name'] . '] Label: ' . $field['label'] . ', Type: ' . $field['type'] . ', Required: ' . $isFieldRequired .'</li>';
                                }
                                echo '</ul></td>';
                                echo '<td><a href="?page=engage-settings&page=engage-settings-manage-forms&edit=' . $form->Id . '" title="Edit" class="tools"><span class="dashicons dashicons-edit"></span></a></td>';
                                echo '</tr>';
                            }
                        }
                        else 
                        {
                            echo '<tr><td colspan="5">No forms available. <a href="?page=engage-settings-manage-forms">Create a new Form</a></td></tr>';
                            LogHelper::WriteWarning('SettingsOverviewForms.php - No forms available. This could be due an error as well.');
                        }
                echo '</table>
                </div>
            </div>';        
    }

    function engage_settings_getinboundeventname($engageInboundEventModel, $inboundEventId)
    {
        //Fall back if name can't be found...
        $inboundEventName = $inboundEventId;

        if($engageInboundEventModel != null && count($engageInboundEventModel)) 
        {
            foreach ($engageInboundEventModel as $event) {
                if($event->Id == $inboundEventId) {
                    $inboundEventName = $event->Name;
                    break;
                }
            }
        }
        else 
        {
            LogHelper::WriteWarning('SettingsOverviewForms.php - Translate inbound event Id to name failed. This could be due an error.');
        }

        return $inboundEventName;
    }

}