<?php

namespace Engage\Settings;

use Engage\Model;
use Engage\DB;
use Engage\Proxies;
use Engage\Helpers\LogHelper;

class SettingsManageForms
{

    

    function engage_settings_manageforms() 
    {
        $success_message = '';
        $error_message = '';
        $dbaccess = new DB\DBAccess();
        $engageFormModel = new Model\FormModel();
        $editItem = false;

        $apiStatusResult = false;
        $proxyengage = new Proxies\Proxy();
        $apiStatusResult = $proxyengage->engage_proxyengage_validate();
        
        if(!$apiStatusResult) 
        {
            LogHelper::WriteWarning('SettingsManageForms.php - Api credentials invalid, redirect to the Api Settings page');
            echo '<meta http-equiv="refresh" content="0;url=' . get_home_url() . '/wp-admin/admin.php?page=engage-settings-api-settings" />';
            exit;
        }        

        /* Edit query string defines if it's a new or an existing form */
        if (isset($_GET['edit']) && is_numeric($_GET['edit'])) 
        {
            $idForm = $_GET['edit'];
            LogHelper::WriteDebug('SettingsManageForms.php - Edit Form (' . $idForm . ')');
            $engageFormModel = $dbaccess->engage_dbaccess_get_engage_form($idForm);            
            $editItem = true;
        }

        // Save settings when the form is submitted
        if (isset($_POST['engage_save_manageforms_settings'])) 
        {
            // Check nonce for security
            if ( ! isset( $_POST['engage_settings_manageform_nonce'] ) || ! wp_verify_nonce( $_POST['engage_settings_manageform_nonce'], 'engage_settings_manageform_nonce' ) ) 
            {
                LogHelper::WriteError('SettingsManageForms.php - Save - nonce does not match!');
                wp_die( 'Security check' );
            }
    
            // Get Form data general
            $engageFormModel->Id = sanitize_text_field($_POST['engage_id']);
            $engageFormModel->InboundEventId = sanitize_text_field($_POST['engage_inbound_event']);
            $engageFormModel->Name = sanitize_text_field($_POST['engage_name']);
            $engageFormModel->Fields = array();
            $engageFormModel->Confirmation = wp_kses_post(nl2br($_POST['engage_confirmation_message']));
            
            // Get Form data fields
            foreach ($_POST as $key => $value) 
            {
                if (strpos($key, 'field_name') === 0) 
                {
                    $fieldName = sanitize_text_field($value);
                    $fieldLabel = is_null($_POST['field_label_' . $value]) || $_POST['field_label_' . $value] == '' ? ucfirst(strtolower(sanitize_text_field($value))) : sanitize_text_field($_POST['field_label_' . $value]);
                    $fieldType = sanitize_text_field($_POST['field_type_' . $value]);
                    $fieldRequired = isset($_POST['field_required_' . $value]) && sanitize_text_field($_POST['field_required_' . $value]) == 'on' || $value == 'EMAIL' || $fieldType == 'checkbox' ? true : false;
                    $fieldOrder = sanitize_text_field($_POST['field_order_' . $value]);

                    $fieldData = [
                        'name' => $fieldName,
                        'label' => $fieldLabel,
                        'type' => $fieldType,
                        'required' => $fieldRequired,
                        'order' => $fieldOrder,           
                    ];
                    
                    $engageFormModel->Fields[] = $fieldData;                    
                }
            }

            //Validation required fields
            if($engageFormModel->InboundEventId === null || $engageFormModel->InboundEventId == 0) 
            {
                $error_message = "Please select an inbound event";
                LogHelper::WriteWarning('SettingsManageForms.php - Save - ' . $error_message);
            }
            else if($engageFormModel->Name === null || $engageFormModel->Name === '') 
            {
                $error_message = "Please fill in a Form Name";
                LogHelper::WriteWarning('SettingsManageForms.php - Save - ' . $error_message);
            }
            else if($engageFormModel->Fields === null || count($engageFormModel->Fields) == 0) 
            {
                $error_message = "No inbound fields found";
                LogHelper::WriteWarning('SettingsManageForms.php - Save - ' . $error_message);
            }
            else 
            {
                LogHelper::WriteDebug('SettingsManageForms.php - Save - Form Data:');
                LogHelper::WriteDebug($engageFormModel);

                //Create or Update Form in db
                LogHelper::WriteDebug('SettingsManageForms.php - Save - Create or Update Form in db');     
                $dbresult = $dbaccess->engage_dbaccess_manage_engage_form($engageFormModel);

                if($dbresult == null) 
                {
                    $error_message = "SettingsManageForms.php - Error inserting form data. Please check the log file.";
                    LogHelper::WriteError('SettingsManageForms.php - Save - DB: An error occured. Check previous message.');
                }
                else if ($dbresult->last_error) 
                {
                    $error_message = "Error inserting data: " . $wpdb->last_error;
                    LogHelper::WriteError('SettingsManageForms.php - Save - DB: ' . $error_message);
                } 
                else if(!$editItem) 
                {
                    LogHelper::WriteDebug('SettingsManageForms.php - Save - Successfull created a new form id: ' . $dbresult->insert_id);
                    $success_message = '<div>
                            <p>Form succesfull created with id ' . $dbresult->insert_id . '</p><br/>
                            <a href="?page=engage-settings-manage-forms">Create a new Form</a>
                    </div>';                
                }
                else 
                {
                    LogHelper::WriteDebug('SettingsManageForms.php - Save - Successfull saved updated form with id: ' . $engageFormModel->Id);
                    $success_message = '<div>
                            <p>Form succesfull updated with id ' . $engageFormModel->Id . '</p><br/>
                            <a href="?page=engage-settings-manage-forms&edit=' . $engageFormModel->Id . '">Edit form \'' . $engageFormModel->Name . '\'</a>
                    </div>';                
                }                   
            }
        }

        LogHelper::WriteDebug('SettingsManageForms.php - Get Engage Inbound Events');
        $proxyengage = new Proxies\Proxy();
        $engageInboundEventModel = $proxyengage->engage_proxyengage_getinboundevents();

        if($engageInboundEventModel != null && count($engageInboundEventModel) > 0)
        {
            LogHelper::WriteDebug('SettingsManageForms.php - Available Engage Inbound Events: ');
            LogHelper::WriteDebug($engageInboundEventModel);

            /* Start rendering snippet */
            echo '<form method="post">';
                echo '<div class="postbox"  id="engage_settings_manageforms">
                        <h3 class="hndle">Forms Management</h3>
                            <div class="inside">';

                                if ($success_message) {
                                    echo '<div class="notice notice-success is-dismissible">
                                        <p>' . $success_message . '</p>
                                    </div>';
                                    die;
                                }
                                else if ($error_message) {
                                    echo '<div class="notice notice-error is-dismissible">
                                        <p>' . $error_message . '</p>
                                    </div>';
                                }            
                            
                                wp_nonce_field( 'engage_settings_manageform_nonce', 'engage_settings_manageform_nonce' );
                                
                                echo'<div>
                                        <input type="hidden" name="engage_id" value="' . $engageFormModel->Id . '"/>
                                        <table class="form-table manage-forms-main" style="width:450px;">
                                        <tr>
                                            <td scope="row"><label for="engage_domain">Inbound Event <span style="color:red;">*</span></label></td>                     
                                            <td>
                                                <select id="engage_inbound_event" name="engage_inbound_event">
                                                    <option value="0">select...</option>';
                                                    foreach ($engageInboundEventModel as $event) {
                                                        $selected = '';
                                                        if($engageFormModel->InboundEventId == $event->Id) $selected = ' selected="selected" ';
                                                        echo '<option value="' . $event->Id . '" ' .  $selected . '>'. $event->Name .'</option>';
                                                    }
                                                echo '</select>
                                                <p class="description">Select an inbound event from Engage.</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td scope="row"><label for="engage_name">Form Name <span style="color:red;">*</span></label></td>
                                            <td>
                                                <input type="text" name="engage_name" value="' . $engageFormModel->Name . '"/>
                                                <p class="description">Fill in the name of the form.</p>
                                            </td>
                                        </tr>                    
                                    </table>
                                </div>
                        </div>
                    </div>                    
                    <div class="postbox">
                        <h3 class="hndle">Fields</h3>
                        <div class="inside"> 
                            <img class="engage-loading" src="' . ENGAGE_PLUGIN_URL . '/assets/loading.gif"/>                       
                            <div id="engage-form-fields">';
                            if($engageFormModel->InboundEventId > 0) {
                                echo $proxyengage->engage_proxyengage_getinboundevent($engageFormModel);
                            }
                            else {
                                echo '<p>Select an inbound event</p>';
                            }
                            echo'</div>
                        </div>
                    </div>
                    <div class="postbox">
                        <h3 class="hndle">Confirmation message</h3>
                        <div class="inside">';
                        $settings = array(
                            'wpautop' => true,
                            'media_buttons' => false,
                            'tinymce' => array(
                                'theme_advanced_buttons1' => 'formatselect,|,bold,italic,underline,|,' .
                                    'bullist,|,justifyleft,justifycenter' .
                                    ',justifyright,justifyfull,|,link,unlink,|' .
                                    ',spellchecker,wp_fullscreen',
                    
                            ),
                            'quicktags' => false
                        );
                        wp_editor($engageFormModel->Confirmation, 'engage_confirmation_message', $settings );        
                        echo '</div>
                    </div>                

                    <p class="submit">
                        <input type="submit" name="engage_save_manageforms_settings" class="button-primary" value="'. ($editItem ? 'Update Form' : 'Add Form') . '" />
                    </p>
                </form>';  
            }
            else 
            {
                LogHelper::WriteError('SettingsManageForms.php - Could not load Engage Inbound Events. This could be due an error from the api or when no inbound events were used in one the custom jouneys within SMC.');
                echo '<div class="notice notice-error is-dismissible">
                    <p>No inbound events available. <br/>Check if the api is active and if there are active journeys which include a wordpress inbound event.</p>
                </div>';
            }
            
        ?>
        <script>
            /* Sort form fields */
            jQuery(document).ready(function() 
            {
                jQuery(function () {
                    jQuery("#engage-form-fields").sortable({
                        items: 'tr', // Selects entire rows
                        handle: '.column_drag', // Specifies the handle for dragging as the first column
                        dropOnEmpty: false,
                        start: function (G, ui) {
                            ui.item.addClass("select");
                        },
                        stop: function (G, ui) {
                            ui.item.removeClass("select");
                            
                            jQuery(this).find("tr").each(function (ordernr) {
                                if (ordernr > 0) {
                                    jQuery(this).find("td.column_order input").val(ordernr);
                                }
                            });
                        }
                    });
                });
            });
        </script>
        <?php
    }
}

