<?php
namespace Engage\Settings;

use Engage\Proxies;
use Engage\Helpers\LogHelper;

class SettingsGeneral 
{
    function engage_settings_general() 
    {
        $success_message = '';
        $error_message = '';

        LogHelper::WriteDebug('SettingsGeneral.php - Display General tab');

        // Save settings when the form is submitted
        if (isset($_POST['engage_save_general_settings'])) 
        {
            // Check nonce for security
            if ( ! isset( $_POST['engage_settings_nonce'] ) || ! wp_verify_nonce( $_POST['engage_settings_nonce'], 'engage_settings_nonce' ) ) 
            {
                LogHelper::WriteError('SettingsGeneral.php - Save - nonce does not match!');
                wp_die( 'Security check' );
            }

            $saved = true;
            $valid = true;
    
            // Save settings
            $form_engage_domain = sanitize_text_field($_POST['engage_domain']);
            $form_engage_clientid = sanitize_text_field($_POST['client_id']);
            $form_engage_clientsecret = sanitize_text_field($_POST['client_secret']);
            
            //Save Api Setting Domain option
            if(esc_attr(get_option('engage_api_domain')) != $form_engage_domain ) 
            {
                //add https:// if the url doesn't start with http (this allows us to still support http aswell)'
                if (strpos($form_engage_domain, 'http') !== 0) {

                    $form_engage_domain = 'https://' . $form_engage_domain;
                }

                //The url may not end with a /, remove if it exists
                $form_engage_domain = rtrim($form_engage_domain, '/');

                $saved = update_option('engage_api_domain', $form_engage_domain);
                LogHelper::WriteDebug('SettingsGeneral.php - Save - Domain: (' . $form_engage_domain . ') save result: ('. $saved .')');
            }

            //Save Api Setting ClientId option
            if(esc_attr(get_option('engage_api_client_id')) != $form_engage_clientid && $saved) 
            {
                $saved = update_option('engage_api_client_id', $form_engage_clientid);
                LogHelper::WriteDebug('SettingsGeneral.php - Save - ClientID result: ('. $saved .')');
            }

            //Save Api Setting ClientSecret option
            if(esc_attr(get_option('engage_api_client_secret')) != $form_engage_clientsecret && $saved) 
            {
                $saved = update_option('engage_api_client_secret', $form_engage_clientsecret);
                LogHelper::WriteDebug('SettingsGeneral.php - Save - ClientSecret result: ('. $saved .')');
            }

            //Domain is required check
            if($form_engage_domain === null || $form_engage_domain === '') 
            {
                $valid= false;
                $error_message = "Please fill in the domain name";
                LogHelper::WriteWarning('SettingsGeneral.php - Save - ' . $error_message);
            } //Clientid is required check
            else if($form_engage_clientid === null || $form_engage_clientid === '') 
            {
                $valid = false;
                $error_message = "Please fill in the client id";
                LogHelper::WriteWarning('SettingsGeneral.php - Save - ' . $error_message);
            } //Clientsecret is required check
            else if($form_engage_clientsecret === null || $form_engage_clientsecret === '') 
            {
                $valid = false;
                $error_message = "Please fill in the client secret";
                LogHelper::WriteWarning('SettingsGeneral.php - Save - ' . $error_message);
            }

            //If save success, else...
            if ($saved && $valid) 
            {
                $success_message = 'Settings saved successfully.';
                LogHelper::WriteDebug('SettingsGeneral.php - Save - ' . $success_message .')');
                //Refresh page
                echo '<meta http-equiv="refresh" content="0;url=' . get_home_url() . '/wp-admin/admin.php?page=engage-settings-api-settings" />';
                exit;
            } 
            else 
            {
                if(!$saved) $error_message = 'Failed to save settings: ' . $error_message;
                LogHelper::WriteError('SettingsGeneral.php - Save - ' . $error_message .')');
            }
            
        }

        /* Start rendering snippet */
        $proxyengage = new Proxies\Proxy();
        $statusColor = $proxyengage->engage_proxyengage_validate() ? "green" : "red";
        
        echo '<div class="postbox" id="engage_settings_general">
                <h3 class="hndle"><span class="server-status dashicons dashicons-admin-site engage-indicator ' . $statusColor . '"></span>Api Settings</h3>
                    <div class="inside">';

                        if ($success_message) {
                            echo '<div class="notice notice-success is-dismissible">
                                <p>' . $success_message . '</p>
                            </div>';
                        }
                        else if ($error_message) {
                            echo '<div class="notice notice-error is-dismissible">
                                <p>' . $error_message . '</p>
                            </div>';
                        }

                        echo '<div id="tab_content">
                            <p>Add your Engage API service account Key & Secret, you can find this on the <a href="https://getstarted.meetmarigold.com/engage/EN/Content/Engage/Admin%20Configuration/AccessManagement-ServiceAccount.htm" target="_blank">Access Management page</a>.<br/></p>
                            <form method="post">';
                                wp_nonce_field( 'engage_settings_nonce', 'engage_settings_nonce' );
                                echo '<table class="form-table">
                                    <tr>
                                        <th scope="row"><label for="engage_domain">Engage Domain</label></th>
                                        <td>
                                            <input type="text" id="engage_domain" name="engage_domain" value="';
                                                echo esc_attr(get_option('engage_api_domain')); 
                                                echo '" class="regular-text" />
                                            <p class="description">Fill in your Engage domain. (example: https://{clientname}.slgnt.eu)</p></td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><label for="client_id">Service Account Key</label></th>
                                        <td><input type="password" id="client_id" name="client_id" value="';
                                        echo esc_attr(get_option('engage_api_client_id')); 
                                        echo '" class="regular-text" />
                                        <p class="description">Fill in your service account key (more info <a href="https://getstarted.meetmarigold.com/engage/EN/Content/Engage/Admin%20Configuration/AccessManagement-ServiceAccount.htm" target="_blank">here</a>)</p></td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><label for="client_secret">Service Account Secret</label></th>
                                        <td><input type="password" id="client_secret" name="client_secret" value="';
                                        echo esc_attr(get_option('engage_api_client_secret')); 
                                        echo '" class="regular-text" />
                                        <p class="description">Fill in your service account secret (more info <a href="https://getstarted.meetmarigold.com/engage/EN/Content/Engage/Admin%20Configuration/AccessManagement-ServiceAccount.htm" target="_blank">here</a>)</p></td>
                                    </tr>
                                </table>
                                <p class="submit">
                                    <input type="submit" name="engage_save_general_settings" class="button-primary" value="Save Changes" />
                                </p>
                            </form>
                        </div>
                    </div>
        </div>';       
    }
}

?>