<?php
namespace Engage\Settings;

use Engage\Proxies;
use Engage\Helpers\LogHelper;

class SettingsAbout
{
    function engage_settings_about() 
    {
        LogHelper::WriteDebug('SettingsAbout.php - Display About tab');
        
        echo '<div class="postbox" id="engage_settings_about">
                <h3 class="hndle">General Settings</h3>
                <div class="inside">
                    <div id="tab_content">
                        <p>The Engage Form Integrator plugin empowers you to effortlessly configure custom forms within your WordPress website and seamlessly integrate them with your Engage platform. By leveraging shortcode functionality, you can easily embed these forms into your posts, pages, or widgets, enabling streamlined data capture directly from your WordPress site to your Engage account.</p><br/>
                        
                        <p><strong>Key Features:</strong></p>
                        <ul>
                            <li>Custom Form Configuration: Create and customize forms tailored to your specific needs right within the WordPress admin interface.</li>                    
                            <li>Seamless Integration with Engage: Each form you create can be seamlessly connected to an inbound event in your Engage platform. This allows captured data to be automatically sent to your Engage account, ensuring a smooth flow of information between your website and Engage.</li>                    
                            <li>Shortcode Integration: Utilize shortcode functionality to embed your configured forms anywhere on your WordPress site, including posts, pages, and widgets. This provides flexibility in placing forms exactly where you need them to engage with your audience.</li>                    
                            <li>Easy-to-Use Interface: The plugin features an intuitive interface that makes form creation and management a breeze, even for users with minimal technical expertise.</li>                    
                        </ul>
                        <br/>
                        <p><strong>Get Started:</strong><br/>                        
                            Install and activate the Engage Form Integrator plugin from the WordPress plugin repository.
                            Configure your desired forms within the plugin settings, customizing fields and settings to meet your requirements.
                            Use the provided shortcode to embed your forms into your WordPress content, enabling visitors to interact with your forms seamlessly.
                            Watch as form submissions are automatically sent to your Engage account, enabling you to leverage the power of Engage for effective data management and engagement.
                        </p>
                        
                        <p><strong>Support:</strong><br/>                    
                        Create a ticket in our support portal if you encounter an issue or need assistance. <a href="https://support.selligent.com/">Contact Support</a>
                        </p>
                    </div>
                </div>
        </div>';
    }
}

?>