<?php
namespace Engage\Proxies;

use Engage\Model;
use Engage\Helpers\LogHelper;

class Proxy 
{

    function engage_proxyengage_validate()  
    {
        $isvalid = false;

        try
        {
            LogHelper::WriteDebug('Proxy.php - Validate - Get Api credentials');
            $ch = curl_init();
            $endpoint = $this->engage_proxyengage_getendpoint("STATUS");
            $headers = $this->engage_proxyengage_getapicredentials();
            curl_setopt($ch, CURLOPT_URL, $endpoint);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTREDIR, 3);
            
            $response = curl_exec($ch);

            if(curl_errno($ch)) $isvalid = false;            
            else $isvalid = true;
            
            curl_close($ch);
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Validate - Caught exception: ' . $e->getMessage());
            $isvalid = false;
        }
        
        return $isvalid;
    }

    function engage_proxyengage_getinboundevent($engageFormModel) 
    {
        try
        {
            $engageInboundEventModel = $this->engage_proxyengage_receive_inboundevents();

            if($engageInboundEventModel == null) 
            {
                throw new Exception("Could not load Egnage inbound events.");
            }

            foreach ($engageInboundEventModel as $event) 
            {
                if($event->Id == $engageFormModel->InboundEventId) 
                {
                    $selectedEngageInboundEventModel = $event;
                    break;
                }
            }

            $formFieldRows = [];

            echo '<table>';
            echo '<tr><th></th><th>Name</th><th>Label</th><th>Type</th><th>Required</th><th></th></tr>';

            $rowIndex = 1;

            foreach ($selectedEngageInboundEventModel->Fields as $index => $field) 
            {
                
                $fieldLabel = '';
                $fieldType = 'text';
                $fieldRequired='';
                $fieldOrder = ++$index;

                foreach ($engageFormModel->Fields as $formField) 
                {
                    if($field == $formField['name']) $fieldType = $formField['type'];
                    if($field == $formField['name'] && $formField['label'] != null) $fieldLabel = $formField['label']; 
                    if($field == $formField['name']) $fieldRequired = $formField['required'];    
                    if($field == $formField['name']) $fieldOrder = $formField['order'];               
                }

                if($field == 'EMAIL' || $fieldType == 'checkbox') 
                {
                    $fieldRequired = 'checked disabled';
                }
                else if($fieldRequired)
                {
                    $fieldRequired = 'checked';
                }

                $fieldRow = '<tr>
                        <td class="column_drag"><span class="dashicons dashicons-menu"></span></td>
                        <td class="column_name"><label>' . $field . '</label><input type="hidden" name="field_name_' . $field . '" value="' . $field . '" /></td>
                        <td class="column_label"><input type="text" placeholder="Fill in a label name..." name="field_label_' . $field . '" value="' . $fieldLabel . '" /></td>
                        <td class="column_type">
                            <select class="form-management-field-type" name="field_type_' . $field . '">
                                <option value="text" ' . ($fieldType == 'text' ? 'selected="selected"' : '') . '>Text</option>
                                <option value="textarea" ' . ($fieldType == 'textarea' ? 'selected="selected"' : '') . '>TextArea</option>
                                <option value="checkbox" ' . ($fieldType == 'checkbox' ? 'selected="selected"' : '') . '>Checkbox</option>
                            </select>
                        </td>
                        <td class="column_required"><input class="form-management-field-required" type="checkbox" name="field_required_' . $field . '" ' . $fieldRequired . '/></td>
                        <td class="column_order"><input type="hidden" name="field_order_' . $field . '" value="' . $fieldOrder . '"/></td>
                    </tr>';

                $fieldRows[$fieldOrder] = $fieldRow;
            } 

            // Sort the array keys numerically
            ksort($fieldRows);

            // Print the <tr> contents in sorted order
            foreach ($fieldRows as $fieldRow) {
                echo $fieldRow;
            }

            echo '</table>';
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Get Inbound Events - Caught exception: ' . $e->getMessage());
            echo '<p>An error occurred loading the inboudn event fields: ' .  $e->getMessage() . '</p>';
        }            
    }

    function engage_proxyengage_getinboundevents() 
    {
        return $this->engage_proxyengage_receive_inboundevents();
    }

    function engage_proxyengage_getapicredentials() 
    {        
        try 
        {
            $engage_api_clientid = esc_attr(get_option('engage_api_client_id'));
            $engage_api_clientsecret = esc_attr(get_option('engage_api_client_secret'));

            return array(
                    'X-ApiKey: ' . $engage_api_clientid . ':' . $engage_api_clientsecret, 
                    'Content-Type: application/json'
                );
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Get Api Credentials - Caught exception: ' . $e->getMessage());
            return array();
        }  
    }

    function engage_proxyengage_getendpoint($method) 
    {
        try 
        {
            $engage_api_domain = esc_attr(get_option('engage_api_domain'));
            $endpoint = '';
            
            switch ($method) {
                case "STATUS":
                    $endpoint = $engage_api_domain . '/Portal/Api/Status';
                    break;
                case "WORDPRESS":
                    $endpoint =  $engage_api_domain . '/Portal/Api/Inbound/WordPress';
                    break;
            }
            
            return $endpoint;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Get Endpoint method (' . $method . ') - Caught exception: ' . $e->getMessage());
            return '';
        }  
    }

    function engage_proxyengage_receive_inboundevents() 
    {
        try 
        {
            $ch = curl_init();
            $endpoint = $this->engage_proxyengage_getendpoint("WORDPRESS");
            $headers = $this->engage_proxyengage_getapicredentials();
            curl_setopt($ch, CURLOPT_URL, $endpoint);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTREDIR, 3);
            
            $response = curl_exec($ch);

            if(curl_errno($ch)) {
                echo 'Error: ' . curl_error($ch);
            }
            
            curl_close($ch);

            $engageInboundEventModel  = Array();
            $inbound_events = json_decode($response);
            foreach ($inbound_events->inbound_events as $event) {
                $engageInboundEventModel[] = new Model\InboundEventModel($event->id, $event->name, $event->fields);
            }

            return $engageInboundEventModel;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Receive Inbound Events - Caught exception: ' . $e->getMessage());
            return null;
        }              
    }

    function engage_proxyengage_sendinboundevent($engageFormModel, $engageFormNonce) 
    {
        try 
        {
            if( !wp_verify_nonce( $engageFormNonce, 'engage_form_nonce')) 
            {
                LogHelper::WriteError('Proxy.php - Send Inbound Events - Nonce does not match!');

                // Set the HTTP response header to 400
                header('Content-Type: application/json', true, 400);

                // Create the response array
                $response = array(
                    'code'    => 'rest_bad_request',
                    'message' => 'Security check failed: invalid request token. Please refresh the page and try again.',
                    'data'    => array('status' => 400)
                );

                // Output the response in JSON format
                echo json_encode($response);

                // Stop further execution
                exit;
            }

            LogHelper::WriteDebug('Proxy.php - Send Inbound Events - data: ');
            LogHelper::WriteDebug($engageFormModel);

            $engageFormModel->Email = sanitize_email($engageFormModel->Email);

            // Decode the JSON string in the Data field
            $dataArray = json_decode($engageFormModel->Data, true);

            // Check if JSON decoding was successful
            if (json_last_error() === JSON_ERROR_NONE) {
                // Sanitize each field in the array
                foreach ($dataArray as $key => $value) {
                    $dataArray[$key] = sanitize_text_field($value);
                }

                // Encode the array back to a JSON string
                $engageFormModel->Data = json_encode($dataArray);

                // Output the updated object for verification
                
            } else {
                echo "JSON decoding error: " . json_last_error_msg();
            }

            // Encode the data as JSON string
            $jsonData = json_encode($engageFormModel);
            
            $ch = curl_init();
            $endpoint = $this->engage_proxyengage_getendpoint("WORDPRESS");
            $headers = $this->engage_proxyengage_getapicredentials();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $endpoint,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $jsonData,
                CURLOPT_HTTPHEADER => $headers,
            ));
            
            $response = curl_exec($ch);

            if(curl_errno($ch)) {
                LogHelper::WriteError('Error sending the request to Engage: ' . curl_error($ch));
                $response = array(
                    'code'    => 'rest_bad_request',
                    'message' => 'Sorry, we were unable to send your data at this time. Please try again later or contact support for assistance.',
                    'data'    => array('status' => 400)
                );

                // Output the response in JSON format
                echo json_encode($response);
            }
            
            curl_close($ch);
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Proxy.php - Send Inbound Events - Caught exception: ' . $e->getMessage());
            $response = array(
                'code'    => 'rest_bad_request',
                'message' => 'Sorry, we were unable to send your data at this time. Please try again later or contact support for assistance.',
                'data'    => array('status' => 400)
            );
        }
    }

}

?>