<?php
namespace Engage\Helpers;

//use Engage\Helpers;

class FormHelper 
{
    function GetFormElement($name, $label, $elementType, $required) 
    {
        $elementHtml = '';
        $requiredLabel = '';
        $requiredMark = '';

        if($required) 
        {
            $requiredLabel = '<span class="required">*</span>';
            $requiredMark = 'required';
        }

        switch ($elementType) {
            case 'checkbox':
                $elementHtml = '<tr class="form-label form-checkbox">
                                    <td>
                                        <input type="checkbox" id="field_' . $name . '" name="field_' . $name . '" value="">
                                        <label for="' . $name . '">' . $label . '</label>                                        
                                    </td>
                                </tr>';
                break;
            case 'textarea':
                $elementHtml = '<tr class="form-label">
                                    <td colspan="2">
                                        <label for="' . $name . '">' . $label . $requiredLabel  . '</label>
                                    </td>
                                </tr>
                                <tr class="form-element">
                                    <td colspan="2">
                                        <textarea id="field_' . $name . '" name="field_' . $name . '" value="" ' . $requiredMark . '></textarea>
                                        <div id="error_' . $name . '" class="engage_error"></div>
                                    </td>
                                </tr>';
                break;                                        
            case 'input':
                default:
                $elementHtml = '<tr class="form-label">
                                    <td>
                                        <label for="' . $name . '">' . $label . $requiredLabel . '</label>                                        
                                    </td>
                                </tr>
                                <tr class="form-element">
                                    <td>
                                        <input type="text" id="field_' . $name . '" name="field_' . $name . '" value="" ' . $requiredMark . '>
                                        <div id="error_' . $name . '" class="engage_error"></div>
                                        
                                    </td>
                                </tr>';
                    break;                        
        }

        return $elementHtml;
    }
}

