<?php 
    /* 
        Plugin name: Marigold Engage
        URI: https://www.selligent.com/
        Description: Create forms in Wordpress and synchronize data in Marigold Engage for follow up actions.
        Author: MariGold
        Author URI: https://www.selligent.com/
        Version: 1.1 
    */  

    namespace Engage;

    require 'Model/InboundEventModel.php';
    require 'Model/FormModel.php';
    require 'Model/FormPostModel.php';
    require 'DB/DBAccess.php';
    require 'Helpers/FormHelper.php';
    require 'Helpers/LogHelper.php';
    require 'Proxies/Proxy.php';
    require 'Settings/SettingsAbout.php';
    require 'Settings/SettingsGeneral.php';
    require 'Settings/SettingsManageForms.php';
    require 'Settings/SettingsOverviewForms.php';
    require 'ShortCode/FormRender.php';

	use Engage\Model;
    use Engage\DB;
    use Engage\Settings;
	use Engage\Proxy;
    use Engage\Helpers\LogHelper;

    /**
     * The current version of the plugin.
     *
     * @since 1.1.0
     * @var   const    $version    The current version of the plugin.
     */
    if ( ! defined( 'ENGAGE_PLUGIN_VERSION' ) ) {
        define( 'ENGAGE_PLUGIN_VERSION', '1.1.0' );
    }

    if ( ! defined( 'ENGAGE_PLUGIN_PATH' ) ) {
        define( 'ENGAGE_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
    }

    if ( ! defined( 'ENGAGE_PLUGIN_URL' ) ) {
        define( 'ENGAGE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
    }
	
    $inbound_events = [];

    // Define plugin settings page
    function engage_settings_page() 
    {
        \Engage\engage_tab_settingsmaster_page();
    }

    function engage_tab_settingsmaster_page() 
    {
        /* Get api status */
        $apiStatusResult = false;
        $proxyengage = new Proxies\Proxy();
        $apiStatusResult = $proxyengage->engage_proxyengage_validate();
        if(!$apiStatusResult) LogHelper::WriteWarning('Engage.php - The api credentials are not valid.');
        else LogHelper::WriteDebug('Engage.php - The api credentials are valid.');

        ?>
        <div class="wrap" id="Engage">
            <h2>Marigold Engage Settings</h2>
            
            <h2 class="nav-tab-wrapper">
                <a href="?page=engage-plugin" class="nav-tab <?php echo !isset($_GET['page']) || $_GET['page'] == 'engage-plugin' || $_GET['page'] == 'engage-settings-about' || $_GET['page'] == '' ? 'nav-tab-active' : ''; ?>">About</a>
                <a href="?page=engage-settings-api-settings" class="nav-tab <?php echo isset($_GET['page']) && $_GET['page'] == 'engage-settings-api-settings' ? 'nav-tab-active' : ''; ?>">Api Settings</a>
                <?php if ($apiStatusResult): ?>
                    <a href="?page=engage-settings-manage-forms" class="nav-tab <?php echo isset($_GET['page']) && $_GET['page'] == 'engage-settings-manage-forms' ? 'nav-tab-active' : ''; ?>">Forms Management</a>
                    <a href="?page=engage-settings-overview-forms" class="nav-tab <?php echo isset($_GET['page']) && $_GET['page'] == 'engage-settings-overview-forms' ? 'nav-tab-active' : ''; ?>">Forms Overview</a>
                <?php endif; ?>
            </h2>
            <div id="poststuff">                
                <?php
                $active_tab = isset($_GET['page']) ? $_GET['page'] : 'engage-settings-api-settings';

                switch ($active_tab) {
                    case 'engage-settings-manage-forms':
                        $settingsManageForms = new Settings\SettingsManageForms();
                        $settingsManageForms->engage_settings_manageforms();
                        break;
                    case 'engage-settings-overview-forms':
                        $settingsOverviewForms = new Settings\SettingsOverviewForms();
                        $settingsOverviewForms->engage_settings_overviewforms();
                        break;                        
                    case 'engage-settings-api-settings':
                        $settingsGeneral = new Settings\SettingsGeneral();
                        $settingsGeneral->engage_settings_general();
                        break;
                    case 'engage-settings-about':
                        default:
                            $settingsAbout = new Settings\SettingsAbout();
                            $settingsAbout->engage_settings_about();
                            break;                        
                }                
                ?>
            </div>
        </div>
        
        <?php
    }
    
    
    function engage_tab_settingsmanageforms_page() {
        \Engage\engage_tab_settingsmaster_page();
    }
    
    function engage_tab_settingsoverviewforms_page() {
        \Engage\engage_tab_settingsmaster_page();
    }

    function engage_tab_settingsgeneral_page() {
        \Engage\engage_tab_settingsmaster_page();
    }


    // Register plugin settings page
    function engage_settings_page_init() {
        //Init Menu
        LogHelper::WriteDebug('Engage.php - Init plugin start');

        add_menu_page('Marigold Engage', 'Marigold Engage', 'manage_options', 'engage-plugin', __NAMESPACE__ . '\engage_settings_page', ENGAGE_PLUGIN_URL . 'assets/maigold_logo.png');
        add_submenu_page('engage-plugin', 'API settings', 'API settings', 'manage_options', 'engage-settings-api-settings', __NAMESPACE__ . '\engage_tab_settingsgeneral_page');
        add_submenu_page('engage-plugin', 'Forms Management', 'Forms Management', 'manage_options', 'engage-settings-manage-forms', __NAMESPACE__ . '\engage_tab_settingsmanageforms_page');
        add_submenu_page('engage-plugin', 'Forms Overview', 'Forms Overview', 'manage_options', 'engage-settings-overview-forms', __NAMESPACE__ . '\engage_tab_settingsoverviewforms_page');

        //Init db tables
        LogHelper::WriteDebug('Engage.php - Create missing tables if needed.');
        $dbaccess = new DB\DBAccess();
        $error_message = '';

        if(!$dbaccess->engage_dbaccess_checkorcreateformstables()) 
        {
            $error_message = 'Error creating the table wp_engage_forms. Please check your log files.';
        }

        if ($error_message) 
        {
            LogHelper::WriteError('Engage.php - ' . $error_message);

            echo '<div class="notice notice-error is-dismissible">';
                echo '<p>' . $error_message . '</p>';
            echo '</div>';
            exit();
        }

        //Init javascript files
        LogHelper::WriteDebug('Engage.php - Init script files');
        wp_enqueue_script( 'jquery-ui-sortable' );
        wp_register_script('engage-script', plugins_url( '/js/engagescript.js', __FILE__ ), array('jquery'), '1.0', true);
        wp_enqueue_script('engage-script');

        //Init css files
        LogHelper::WriteDebug('Engage.php - Init css files');             
        wp_register_style('engage-style', plugins_url( '/css/style.css', __FILE__ ), array(), '1.0', 'all');  
        wp_enqueue_style('engage-style');
    }

    function engage_uninstall_hook() 
    {
        try 
        {
            LogHelper::WriteDebug('Engage.php - Uninstall - Remove Engage Options');
            delete_option('engage_api_domain');
            delete_option('engage_api_client_id');
            delete_option('engage_api_client_secret');

            LogHelper::WriteDebug('Engage.php - Uninstall - Remove table');
            $dbaccess = new DB\DBAccess();
            $dbresult = $dbaccess->engage_dbaccess_uninstall_tables();
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('Engage.php - Uninstall Failed - Caught exception: ' . $e->getMessage());
        }   
    }

    register_uninstall_hook(__FILE__,  __NAMESPACE__ . '\engage_uninstall_hook');
    add_action('admin_menu', __NAMESPACE__ . '\engage_settings_page_init');
?>