<?php
namespace Engage\DB;

use Engage\Model;
use Engage\Helpers\LogHelper;

class DBAccess 
{
    function engage_dbaccess_checkorcreateformstables() 
    {
        try
        {
            LogHelper::WriteDebug('Proxy.php - Check if wp_engage_forms table exists');

            global $wpdb;
            
            $db_errormsg = '';
            $table_name = $wpdb->prefix . 'engage_forms';

            // Check if the table exists
            if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) 
            {
                LogHelper::WriteDebug('Proxy.php - Create wp_engage_forms table does not exists. Create.');

                // Table does not exist, so create it
                $charset_collate = $wpdb->get_charset_collate();

                $sql = "CREATE TABLE $table_name (
                    id mediumint(9) NOT NULL AUTO_INCREMENT,
                    inboundeventid mediumint(9) NOT NULL,
                    name varchar(150) NOT NULL,
                    fields varchar(4000) NOT NULL,
                    confirmation varchar(65535) NULL,
                    createddt datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                    modifieddt datetime NULL,
                    PRIMARY KEY  (id)
                ) $charset_collate;";

                require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
                $result = dbDelta($sql); 

                if ($result === false) 
                {
                    // Handle the error here, such as logging or displaying a message
                    LogHelper::WriteError('DBAccess.php - Create Table - DB Error: ' . $wpdb->last_error);
                    return false;
                }
                else 
                {
                    LogHelper::WriteDebug('Proxy.php - Table wp_engage_forms succesfull created.');
                }
            }        

            return true;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('DBAccess.php - Create Table - Caught exception: ' . $e->getMessage());
            return false;
        }            
    }

    function engage_dbaccess_manage_engage_form($engageFormModel) 
    {
        try
        {
            LogHelper::WriteDebug('DBAccess.php - Insert or Update Form');

            global $wpdb;

            // Assuming your table name is stored in a variable
            $table_name = $wpdb->prefix . 'engage_forms';
            
            // Data to be inserted
            $data = array(
                'inboundeventid' => $engageFormModel->InboundEventId,
                'name' => $engageFormModel->Name,
                'fields' => json_encode($engageFormModel->Fields),
                'confirmation' => $engageFormModel->Confirmation,
            );
            
            // Format of data
            $data_format = array(
                '%d',
                '%s',
                '%s',
                '%s',
            );
            
            // Inserting data into the table
            if ($engageFormModel->Id > 0) 
            {
                LogHelper::WriteDebug('DBAccess.php - Update Form');
                $wpdb->update($table_name, $data, array('ID' => $engageFormModel->Id), $data_format, array('%d'));
            } 
            else 
            {        
                LogHelper::WriteDebug('DBAccess.php - Insert Form');
                $wpdb->insert($table_name, $data, $data_format);
            }

            return $wpdb;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('DBAccess.php - Insert or Update Form - Caught exception: ' . $e->getMessage());
            return null;
        }               
    }

    function engage_dbaccess_get_engage_forms() 
    {
        try
        {
            LogHelper::WriteDebug('DBAccess.php - Get Forms');

            global $wpdb;
        
            $results = $wpdb->get_results("SELECT id, inboundeventid, name, fields FROM {$wpdb->prefix}engage_forms ORDER BY id DESC", ARRAY_A);
        
            $forms = array();
        
            foreach ($results as $result) {
                $form = new Model\FormModel($result['id'], $result['inboundeventid'], $result['name'], json_decode($result['fields'], true));
                $forms[] = $form;
            }
        
            return $forms;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('DBAccess.php - Get Forms - Caught exception: ' . $e->getMessage());
            return null;
        } 
    }

    function engage_dbaccess_get_engage_form($id) 
    {
        try
        {
            LogHelper::WriteDebug('DBAccess.php - Get Form with id: ' . $id);

            global $wpdb;

            $query = $wpdb->prepare("SELECT * FROM {$wpdb->prefix}engage_forms WHERE id = %d", $id);
            $result = $wpdb->get_row($query);

            if($result != null) $form = new Model\FormModel($result->id, $result->inboundeventid, $result->name, json_decode($result->fields, true), $result->confirmation);
            else return null;
        
            return $form;
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('DBAccess.php - Get Form with ID (' . $id . ') - Caught exception: ' . $e->getMessage());
            return null;
        }         
    }

    function engage_dbaccess_uninstall_tables() 
    {
        try
        {
            LogHelper::WriteDebug('DBAccess.php - Uninstall triggered: Drop table wb_engage_forms');        
            global $wpdb;
            $table_name = $wpdb->prefix . 'engage_forms';
            $wpdb->query("DROP TABLE IF EXISTS $table_name");
        }
        catch (Exception $e) 
        {
            LogHelper::WriteError('DBAccess.php - Unable to drop table wb_engage_forms - Caught exception: ' . $e->getMessage());
        }    
    }
}

?>